/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProdosFileEntry
extends ProdosCommonEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();

    public ProdosFileEntry(ProdosFormatDisk disk, int block, int offset) {
        super(disk, block, offset);
    }

    @Override
    public String getFilename() {
        String fileName;
        if (this.isDeleted()) {
            char ch;
            fileName = AppleUtil.getString(this.readFileEntry(), 1, 15);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < fileName.length() && (ch = fileName.charAt(i)) != '\u0000'; ++i) {
                buf.append(ch);
            }
            fileName = buf.toString();
        } else {
            fileName = AppleUtil.getProdosString(this.readFileEntry(), 0);
        }
        if (this.isAppleWorksFile()) {
            int auxtype = this.getAuxiliaryType();
            StringBuffer mixedCase = new StringBuffer(fileName);
            for (int i = 0; i < 16 && i < fileName.length(); ++i) {
                boolean lowerCase = i < 8 ? AppleUtil.isBitSet((byte)auxtype, 7 - i) : AppleUtil.isBitSet((byte)(auxtype >> 8), 7 - i % 8);
                if (!lowerCase) continue;
                char ch = mixedCase.charAt(i);
                if (ch == '.') {
                    mixedCase.setCharAt(i, ' ');
                    continue;
                }
                mixedCase.setCharAt(i, Character.toLowerCase(ch));
            }
            fileName = mixedCase.toString();
        }
        return fileName;
    }

    @Override
    public int getMaximumFilenameLength() {
        return 15;
    }

    @Override
    public void setFilename(String filename) {
        byte[] fileEntry = this.readFileEntry();
        if (this.isDeleted()) {
            AppleUtil.setString(fileEntry, 1, filename.toUpperCase(), 15);
        } else {
            AppleUtil.setProdosString(fileEntry, 0, filename.toUpperCase(), 15);
        }
        if (this.isAppleWorksFile()) {
            byte lowByte = 0;
            byte highByte = 0;
            for (int i = 0; i < filename.length(); ++i) {
                if (!Character.isLowerCase(filename.charAt(i))) continue;
                if (i < 8) {
                    lowByte = AppleUtil.setBit(lowByte, 7 - i);
                    continue;
                }
                if (i >= 16) continue;
                highByte = AppleUtil.setBit(highByte, 7 - i % 8);
            }
            this.setAuxiliaryType(fileEntry, lowByte, highByte);
        }
        this.writeFileEntry(fileEntry);
    }

    public void setGEOSMeta(byte[] metaData) {
        byte[] fileEntry = this.readFileEntry();
        System.arraycopy(metaData, 384, fileEntry, 0, 17);
        System.arraycopy(metaData, 408, fileEntry, 24, 6);
        System.arraycopy(metaData, 417, fileEntry, 33, 4);
        this.writeFileEntry(fileEntry);
    }

    @Override
    public String getFiletype() {
        int filetype = this.getFiletypeByte();
        this.getDisk();
        return ProdosFormatDisk.getFiletype(filetype);
    }

    public int getFiletypeByte() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[16]);
    }

    @Override
    public void setFiletype(String filetype) {
        byte[] entry = this.readFileEntry();
        entry[16] = this.getDisk().getFiletype(filetype);
        this.writeFileEntry(entry);
    }

    public void setFiletype(long fileType) {
        byte[] entry = this.readFileEntry();
        entry[16] = (byte)fileType;
        this.writeFileEntry(entry);
    }

    public boolean isAppleWorksFile() {
        int filetype = AppleUtil.getUnsignedByte(this.readFileEntry()[16]);
        return filetype == 25 || filetype == 26 || filetype == 27;
    }

    public boolean isGEOSFile() {
        int filetype = AppleUtil.getUnsignedByte(this.readFileEntry()[16]);
        return filetype >= 128 && filetype <= 143;
    }

    public boolean isForkedFile() {
        int storageType = AppleUtil.getUnsignedByte(this.readFileEntry()[0]);
        return (storageType & 0x50) == 80;
    }

    public int getKeyPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 17);
    }

    public void setKeyPointer(int keyPointer) {
        byte[] entry = this.readFileEntry();
        AppleUtil.setWordValue(entry, 17, keyPointer);
        this.writeFileEntry(entry);
    }

    public int getBlocksUsed() {
        return AppleUtil.getWordValue(this.readFileEntry(), 19);
    }

    public void setBlocksUsed(int blocksUsed) {
        byte[] entry = this.readFileEntry();
        AppleUtil.setWordValue(entry, 19, blocksUsed);
        this.writeFileEntry(entry);
    }

    public int getEofPosition() {
        return AppleUtil.get3ByteValue(this.readFileEntry(), 21);
    }

    public void setEofPosition(int eofPosition) {
        byte[] entry = this.readFileEntry();
        AppleUtil.set3ByteValue(entry, 21, eofPosition);
        this.writeFileEntry(entry);
    }

    public int getAuxiliaryType() {
        return AppleUtil.getWordValue(this.readFileEntry(), 31);
    }

    public void setAuxiliaryType(int auxiliaryType) {
        byte[] entry = this.readFileEntry();
        this.setAuxiliaryType(entry, auxiliaryType);
        this.writeFileEntry(entry);
    }

    public void setAuxiliaryType(byte[] entry, byte low, byte high) {
        entry[31] = low;
        entry[32] = high;
    }

    public void setAuxiliaryType(byte[] entry, int auxiliaryType) {
        this.setAuxiliaryType(entry, (byte)(auxiliaryType % 256), (byte)(auxiliaryType / 256));
    }

    public Date getLastModificationDate() {
        return AppleUtil.getProdosDate(this.readFileEntry(), 33);
    }

    public void setLastModificationDate(Date date) {
        byte[] entry = this.readFileEntry();
        AppleUtil.setProdosDate(entry, 33, date);
        this.writeFileEntry(entry);
    }

    public int getHeaderPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 37);
    }

    public void setHeaderPointer(int headerPointer) {
        byte[] entry = this.readFileEntry();
        AppleUtil.setWordValue(entry, 37, headerPointer);
        this.writeFileEntry(entry);
    }

    @Override
    public boolean isLocked() {
        return !this.canDestroy() && !this.canRename() && !this.canWrite();
    }

    @Override
    public void setLocked(boolean lock) {
        this.setCanDestroy(!lock);
        this.setCanRename(!lock);
        this.setCanWrite(!lock);
    }

    @Override
    public int getSize() {
        return this.getEofPosition();
    }

    @Override
    public boolean isDirectory() {
        return this.getStorageType() == 13;
    }

    @Override
    public boolean isDeleted() {
        return this.getStorageType() == 0;
    }

    @Override
    public void delete() {
        this.getDisk().freeBlocks(this);
        int headerBlock = this.getHeaderPointer();
        byte[] data = this.getDisk().readBlock(headerBlock);
        int fileCount = AppleUtil.getWordValue(data, 37);
        if (fileCount != 0) {
            --fileCount;
        }
        AppleUtil.setWordValue(data, 37, fileCount);
        this.getDisk().writeBlock(headerBlock, data);
        data = this.readFileEntry();
        data[0] = 0;
        this.writeFileEntry(data);
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.textBundle.get("DateFormat"));
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFilename());
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getBlocksUsed()));
                list.add(this.getLastModificationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : dateFormat.format(this.getLastModificationDate()));
                list.add(this.getCreationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : dateFormat.format(this.getCreationDate()));
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getEofPosition()));
                if ("TXT".equals(this.getFiletype()) && this.getAuxiliaryType() > 0) {
                    numberFormat.setMinimumIntegerDigits(1);
                    list.add("L=" + numberFormat.format(this.getAuxiliaryType()).trim());
                    break;
                }
                if (("BIN".equals(this.getFiletype()) || "BAS".equals(this.getFiletype()) || "VAR".equals(this.getFiletype()) || "SYS".equals(this.getFiletype())) && this.getAuxiliaryType() > 0) {
                    list.add("A=$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                    break;
                }
                list.add("");
                break;
            }
            case 3: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFilename());
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                String permissions = "";
                if (this.canDestroy()) {
                    permissions = permissions + this.textBundle.get("Destroy");
                }
                if (this.canRead()) {
                    permissions = permissions + this.textBundle.get("Read");
                }
                if (this.canRename()) {
                    permissions = permissions + this.textBundle.get("Rename");
                }
                if (this.canWrite()) {
                    permissions = permissions + this.textBundle.get("Write");
                }
                list.add(permissions);
                list.add(this.getFiletype());
                list.add(this.isDirectory() ? this.textBundle.get("ProdosFileEntry.Directory") : "");
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getBlocksUsed()));
                list.add(this.getLastModificationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : dateFormat.format(this.getLastModificationDate()));
                list.add(this.getCreationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : dateFormat.format(this.getCreationDate()));
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getEofPosition()));
                if ("TXT".equals(this.getFiletype()) && this.getAuxiliaryType() > 0) {
                    numberFormat.setMinimumIntegerDigits(1);
                    list.add("L=" + numberFormat.format(this.getAuxiliaryType()).trim());
                } else if (("BIN".equals(this.getFiletype()) || "BAS".equals(this.getFiletype()) || "VAR".equals(this.getFiletype()) || "SYS".equals(this.getFiletype())) && this.getAuxiliaryType() > 0) {
                    list.add("A=$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                } else {
                    list.add("$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                }
                list.add(AppleUtil.getFormattedWord(this.getHeaderPointer()));
                list.add(AppleUtil.getFormattedWord(this.getKeyPointer()));
                list.add(this.isSaplingFile() ? this.textBundle.get("ProdosFileEntry.Sapling") : (this.isSeedlingFile() ? this.textBundle.get("ProdosFileEntry.Seedling") : (this.isTreeFile() ? this.textBundle.get("ProdosFileEntry.Tree") : this.textBundle.format("ProdosFileEntry.UnknownFileType", this.getFileTypeString()))));
                list.add(this.hasChanged() ? this.textBundle.get("ProdosFileEntry.Changed") : "");
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getMinimumProdosVersion()));
                list.add(numberFormat.format(this.getProdosVersion()));
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    public String getFileTypeString() {
        return "$" + AppleUtil.getFormattedByte(this.getStorageType());
    }

    @Override
    public byte[] getFileData() {
        return this.getDisk().getFileData(this);
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
        this.getDisk().setFileData(this, data);
    }

    public void setFileData(byte[] dataFork, byte[] resourceFork) throws DiskFullException {
        this.getDisk().setFileData(this, dataFork, resourceFork);
    }

    @Override
    public FileFilter getSuggestedFilter() {
        int filetype = this.getFiletypeByte();
        int auxtype = this.getAuxiliaryType();
        int filesize = this.getSize();
        switch (filetype) {
            case 4: {
                if (this.getFilename().endsWith(".S")) {
                    return new AssemblySourceFileFilter();
                }
                return new TextFileFilter();
            }
            case 9: {
                return new BusinessBASICFileFilter();
            }
            case 176: {
                return new TextFileFilter();
            }
            case 25: {
                return new AppleWorksDataBaseFileFilter();
            }
            case 26: {
                return new AppleWorksWordProcessorFileFilter();
            }
            case 27: {
                return new AppleWorksSpreadSheetFileFilter();
            }
            case 252: {
                return new ApplesoftFileFilter();
            }
            case 250: {
                return new IntegerBasicFileFilter();
            }
            case 192: {
                if (auxtype != 1) break;
                GraphicsFileFilter filter = new GraphicsFileFilter();
                filter.setMode(5);
                return filter;
            }
            case 193: {
                if (auxtype == 0 || auxtype == 2 && filesize == 32768) {
                    GraphicsFileFilter filter = new GraphicsFileFilter();
                    filter.setMode(5);
                    return filter;
                }
                if (auxtype != 2 || filesize != 38400) break;
                GraphicsFileFilter filter = new GraphicsFileFilter();
                filter.setMode(6);
                return filter;
            }
            case 6: {
                if (filesize >= 8184 && filesize <= 8192) {
                    GraphicsFileFilter filter = new GraphicsFileFilter();
                    filter.setMode(2);
                    return filter;
                }
                if (filesize < 16376 || filesize > 16384) break;
                GraphicsFileFilter filter = new GraphicsFileFilter();
                filter.setMode(4);
                return filter;
            }
            case 202: {
                GraphicsFileFilter filter = new GraphicsFileFilter();
                filter.setMode(7);
                return filter;
            }
        }
        return new BinaryFileFilter();
    }

    @Override
    public boolean needsAddress() {
        return this.getDisk().needsAddress(this.getFiletype());
    }

    @Override
    public void setAddress(int address) {
        byte[] fileEntry = this.readFileEntry();
        this.setAuxiliaryType(fileEntry, address);
        this.writeFileEntry(fileEntry);
    }

    @Override
    public boolean canCompile() {
        return this.getDisk().canCompile(this.getFiletype());
    }
}

